<?php

namespace App\Helpers;

use DOMDocument;

class Helper
{


    public static function truncateHtml($html, $wordLimit = 20, $end = '...')
    {
        libxml_use_internal_errors(true);

        $dom = new DOMDocument();
        @$dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
        libxml_clear_errors();

        $body = $dom->getElementsByTagName('body')->item(0);
        if (!$body) {
            return '';
        }

        $text = '';
        $wordCount = 0;
        $stop = false;

        $traverseNodes = function ($node) use (&$text, &$wordCount, $wordLimit, &$stop, &$traverseNodes) {
            if ($stop) return;

            if ($node->nodeType == XML_TEXT_NODE) {
                $words = preg_split('/\s+/', trim($node->nodeValue));
                $remainingWords = $wordLimit - $wordCount;

                if ($remainingWords <= 0) {
                    $stop = true;
                    return;
                }

                $text .= implode(' ', array_slice($words, 0, $remainingWords)) . ' ';
                $wordCount += count($words);
                if ($wordCount >= $wordLimit) {
                    $stop = true;
                }
            } else {
                foreach ($node->childNodes as $child) {
                    $traverseNodes($child);
                }
            }
        };

        $traverseNodes($body);

        return '<div>' . trim($text) . $end . '</div>';
    }


    public static function cssFilesPath(string $string)
    {
        return url('resources/assets/front/css/' . $string);
    }
    public static function vendorFilesPath(string $string)
    {
        return url('resources/assets/front/vendor/' . $string);
    }

    public static function webfontsFilesPath(string $string)
    {
        return url('resources/assets/front/webfonts/' . $string);
    }

    public static function pluginsFilesPath(string $string)
    {
        return url('resources/assets/plugins/' . $string);
    }

    public static function jsFilesPath(string $string)
    {
        return url('resources/assets/front/js/' . $string);
    }

    public static function imageFilesPath(string $string)
    {
        return url('resources/assets/front/img/' . $string);
    }

    public static function uploadedImagesPath($model, $image)
    {
        return url('uploads/' . $model . '/source/' . $image);
    }

    public static function uploadedSliderImagesPath($model, $image)
    {
        return url('uploads/sliders/' . $model . '/source/' . $image);
    }
}
