<!-- Projects -->
<?php if(count($projects)>0): ?>
    <section class="projects section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="section-title"><?php echo e(__('home.our')); ?> <span><?php echo e(__('home.projects')); ?></span></h2>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="projects4 <?php if($index==1): ?> left <?php endif; ?> animate-box" data-animate-effect="fadeInUp">
                            <figure>
                                <img src="<?php echo e(Helper::uploadedImagesPath('projects',$project->image)); ?>"
                                     alt="<?php echo e($project->img_alt); ?>" class="img-fluid">
                            </figure>
                            <div class="caption">
                                
                                <h4><?php echo e($project->{'name_'.$lang}); ?></h4>
                                <p><?php echo e(strip_tags(mb_strimwidth($project->{'small_text_'.$lang}, 0, 200, "..."))); ?></p>
                                <div class="butn-dark mt-15">
                                    <a href="<?php echo e(LaravelLocalization::localizeUrl('project/'.$project->{'link_'.$lang} )); ?>"><span><?php echo e(__('home.Discover')); ?></span></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="col-12 text-center">
                    <div class="butn-light mt-30 mb-30" data-animate-effect="fadeInUp">
                        <a href="<?php echo e(LaravelLocalization::localizeUrl('projects' )); ?>">
                            <span><?php echo e(__('home.All Projects')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH C:\OSPanel\domains\soulwater\resources\views/website/home-partials/projects.blade.php ENDPATH**/ ?>