@extends('layouts.app')
@section('title')

@endsection
@section('name', 'teams')
@section('BreadCrumb', __('home.Our Doctors'))
@section('BreadCrumb2', __('home.Our Doctors'))
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    @include('website.web-partials.BreadCrumb')
    @include('website.home-partials.slider')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    <!-- <==============services==============> -->
    <div class="page-content">
        <!--====== Broker START ======-->
        <section class="team-section has-slider pt-115 pb-115">
            <div class="container">
                <div class="section-title text-center mb-80">
                    <div class="section-title-icon">
                        <i class="fas fa-user-md"></i>
                    </div>
                </div>
                <div class="row team-loop">
                    @foreach ($teams as $team)
                        <div class="col-lg-4 col-md-6">
                            <div class="member-box">
                                <a>
                                    <div class="member-img">
                                        <img src="{{ Helper::uploadedImagesPath('teams', $team->img) }}" alt="Team-Image">
                                    </div>
                                </a>
                                <a>
                                    <div class="member-info">
                                        <h3>{{ $team->{'name_'.$lang} }}</h3>
                                        <span>{{ $team->{'text_'.$lang}  }}</span>
                                    </div>
                                </a>
                                <div class="social-links">
                                    <ul>
                                        @if ($team->facebook)
                                        <li>
                                            <a href="{{ $team->facebook }}"><i
                                                    class="fab fa-facebook-f"></i></a>
                                        </li>
                                    @endif
                                    @if ($team->instgram)
                                        <li>
                                            <a href="{{ $team->instgram }}"><i
                                                    class="fab fa-instagram"></i></a>
                                        </li>
                                    @endif
                                    @if ($team->linkedin)
                                        <li>
                                            <a href="{{ $team->linkedin }}"><i
                                                    class="fab fa-linkedin"></i></a>
                                        </li>
                                    @endif
                                    @if ($team->youtube)
                                        <li>
                                            <a href="{{ $team->youtube }}"><i
                                                    class="fab fa-youtube"></i></a>
                                        </li>
                                    @endif
                                    </ul>
                                </div>
                                <a href="mailto:{{ $team->email }}" class="socail-trigger">
                                    <i class="flaticon-balance"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!--====== Broker END ======-->
        @include('website.web-partials.boardmembers')
    </div>
    <!-- <==============services==============> -->
@endsection

