@if (count($testimonials) > 0)

<section class="testimonials-2 section-margin section-padding p-relative dsn-swiper"

data-dsn-controller=".testimonial-content" data-dsn-option='{"autoHeight" : "auto"}'>

        @if (Route::currentRouteName() == 'about-us' && Request::segment(2))

            <div class="bg-section p-absolute w-100 h-100 over-hidden top-0">

                <div class="before-z-index h-100" data-dsn-grid="move-up" data-overlay="8">

                    <img class="p-absolute cover-bg-img has-top-bottom"

                        src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="

                        data-dsn-src="{{ Helper::uploadedImagesPath('subheader', $subheader->subheader('reviews', 1)->image) }}"

                        alt="" data-dsn-move="20%">

                </div>

            </div>

        @endif

        <div class="container">

            <div class="row">

                <div class="col-lg-4">

                    <div class="box-title p-relative sm-mb-title">

                        <h5 class="sub-heading mb-15 pb-15">{{ __('home.awesomepartner') }}</h5>

                        <h2 class="section-title mb-15 text-uppercase">

                            {{ Helper::extractFirstWords($subheader->subheader('reviews', 1)->{'title_' . $lang}, 1) }}

                            <strong>

                                {{ Helper::extractLastWords($subheader->subheader('reviews', 1)->{'title_' . $lang}, 1) }}

                            </strong>

                        </h2>

                        <p>{!! $subheader->subheader('reviews', 1)->{'text_' . $lang} !!} </p>

                    </div>

                </div>



                <div class="col-lg-8">

                    <div class="testimonials-inner">

                        <div class="swiper-container">

                            <div class="swiper-wrapper">

                                @foreach ($testimonials as $testimonial)

                                    <div class="swiper-slide testimonial-item">

                                        <p class="subtitle p-relative line-shap  line-shap-after mb-15">

                                            <span

                                                class="pl-10 pr-10 background-section dsn-load-animate">{{ __('home.designquality') }}y</span>

                                        </p>

                                        <p>{!! $testimonial->text !!}</p>



                                        <div class="author-box d-flex align-items-center mt-20">

                                            <div class="avatar mr-15">

                                                <img class="cover-bg-img"

                                                    src="{{ Helper::uploadedImagesPath('testimonials', $testimonial->img) }}"

                                                    alt="">

                                            </div>



                                            <div class="author-text">

                                                <h4 class="sm-title-block mb-10">{{ $testimonial->name }}</h4>

                                                <h5>{{ $testimonial->position }}</h5>

                                            </div>

                                        </div>

                                    </div>

                                @endforeach

                            </div>

                            <div class="dsn-pagination mt-30 d-flex justify-content-between">

                                <div class="swiper-next">

                                    <div class="next-container">

                                        <div class="container-inner">

                                            <div class="triangle"></div>

                                            <svg class="circle" xmlns="http://www.w3.org/2000/svg" width="24"

                                                height="24" viewBox="0 0 24 24">

                                                <g class="circle-wrap" fill="none" stroke-width="1"

                                                    stroke-linejoin="round" stroke-miterlimit="10">

                                                    <circle cx="12" cy="12" r="10.5"></circle>

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </div>

                                <div class="swiper-pagination"></div>

                                <div class="swiper-prev">

                                    <div class="prev-container">

                                        <div class="container-inner">

                                            <div class="triangle"></div>

                                            <svg class="circle" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">

                                                <g class="circle-wrap" fill="none" stroke-width="1"

                                                    stroke-linejoin="round" stroke-miterlimit="10">

                                                    <circle cx="12" cy="12" r="10.5"></circle>

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

@endif

