<!--====== Bureau PART START ======-->
<section class="restaurant-tab-area pb-30 mt-60 team-section container-wide position-relative">
    <div class="container">
        <div class="section-title mb-50 text-center">
            <span class="title-tag">{{ __('home.our team') }}</span>
            <h2>{{ __('home.Eye Care&Scan Doctors') }}</h2>
        </div>
        <!-- tab content -->
        <div class="tab-content " id="restaurant-tabContent">
            <div class="tab-pane fade show active" role="tabpanel">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="block-text">
                            <div class="section-title mb-20">
                                <span class="title-tag">{{ __('home.doctors') }}</span>
                                <h2>{{ __('home.Eye Care Consultants & Specialists') }}</h2>
                            </div>
                            @if (empty(Request::segment(2)))
                                <a href="{{ LaravelLocalization::localizeUrl('teams') }}"
                                    class="main-btn btn-filled mt-40">{{ __('home.view_all') }}</a>
                            @endif
                        </div>
                    </div>
                    <div class="px-2 w-100">
                        <div class="row team-loop wide-Bureau-post-slider mt-80">
                            @foreach ($teams as $team)
                                <div class="col-12">
                                    <div class="member-box">
                                            <div class="member-img">
                                                <img src="{{ Helper::uploadedImagesPath('teams', $team->img) }}"
                                                    alt="Team-Image">
                                            </div>
                                        <div class="member-info">
                                                <h3>{{ $team->{'name_'.$lang} }}</h3>
                                                <span>{{ $team->{'position_'.$lang} }}</span>
                                        </div>
                                        <div class="social-links">
                                            <ul>
                                                @if ($team->facebook)
                                                    <li>
                                                        <a href="{{ $team->facebook }}"><i
                                                                class="fab fa-facebook-f"></i></a>
                                                    </li>
                                                @endif
                                                @if ($team->instgram)
                                                    <li>
                                                        <a href="{{ $team->instgram }}"><i
                                                                class="fab fa-instagram"></i></a>
                                                    </li>
                                                @endif
                                                @if ($team->linkedin)
                                                    <li>
                                                        <a href="{{ $team->linkedin }}"><i
                                                                class="fab fa-linkedin"></i></a>
                                                    </li>
                                                @endif
                                                @if ($team->youtube)
                                                    <li>
                                                        <a href="{{ $team->youtube }}"><i
                                                                class="fab fa-youtube"></i></a>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                        <a href="mailto:{{ $team->email }}" class="socail-trigger">
                                            <i class="flaticon-balance"></i>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--====== Bureau PART END ======-->
