@extends('layouts.admin')
<title>{{trans('home.add')}}</title>
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.albums')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/albums')}}">{{trans('home.albums')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.add_blog_item')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'albums.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="helperText">{{ trans('home.type') }}</label>
                                            <select class="form-control" data-trigger name="type">
                                                <option value="images">Images</option>
                                                <option value="video">Video</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="type">{{ trans('home.sectionname') }}</label>
                                            <select name="section" class="form-control" data-trigger required >
                                                <option value="about">{{ trans('home.about-us') }}</option>
                                                <option value="services">{{ trans('home.services') }}</option>
                                                <option value="blogs">{{ trans('home.blogs') }}</option>
                                                <option value="gallery">{{ trans('home.gallery') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/albums')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

