<title><?php echo e(trans('home.faq')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.faq')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.faq')); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>


    <?php if(session()->has('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <?php echo Form::open(['route' => 'faqs.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="field_wrapper">
                                    <div class="row">
                                        <?php if(count($questions) > 0): ?>
                                            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div  class="col-md-5 mb-3"> 
                                                    <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" readonly value="<?php echo e($question->question); ?>">
                                                </div>
        
                                                <div  class="col-md-5 mb-3">
                                                    <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" readonly><?php echo e($question->answer); ?></textarea>
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#iconForm_<?php echo e($key); ?>"><i class="fas fa-edit"></i></button>
                                                    <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="<?php echo e($question->id); ?>" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                </div>
                                                <div class="col-md-12">
                                                    <hr>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                        <?php else: ?>
                                            <div class="form-group col-md-6"> 
                                                <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]">
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                                            </div> 
                                        <?php endif; ?>
                                    </div>  
                                </div>       
                                <a href="javascript:void(0);" class="add_button btn mb-5" title="Add field"><i class="fas fa-plus-square"></i></a>
                            </div> 
                        </div>
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                            <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                        </div>

                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                    <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <h5 class="modal-title" id="myModalLabel34">X</h5>
                    </a>
                </div>
                <form action="<?php echo e(route('updateFaq')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="question"><?php echo e(trans('home.question')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question" value="<?php echo e($question->question); ?>">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                <textarea type="text"  class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer" ><?php echo e($question->answer); ?></textarea>
                            </div> 

                            <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?> </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        
        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><div  class="col-md-5 mb-3"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
            fieldHTML +='<div  class="col-md-5 mb-3"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-2"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
        
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo e(route('removeFaq')); ?>",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
            
        });

    </script>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\semac\resources\views/admin/faqs/editFaq.blade.php ENDPATH**/ ?>