<h4 class="widget-title"><?php echo e(__('Asked Questions')); ?></h4>
<div class="service-details-form">
    <div class="contact-form">
        <form action="<?php echo e(route('contact.save')); ?>" method="Post" id="ajax-contact" novalidate>
            <?php echo csrf_field(); ?>
            <div class="request-form">
                <div class="form-group row">
                    <div id="success-message" style="color: green;"></div>
                    <div class="mb-3 form-item">
                        <input type="text" class="form-control" placeholder="Your Name" name="name" id="name"
                            style="margin: 0 !important">
                        <div class="print-error-msg" id="error-name" style="display:none; color: red;"></div>
                    </div>
                    <div class="mb-3 form-item col-md-6">
                        <input type="email"class="form-control" placeholder="Email Address" name="email"
                            id="email" style="margin: 0 !important">
                        <div class="print-error-msg" id="error-email" style="display:none; color: red;">
                        </div>
                    </div>

                    <div class="mb-3 form-item col-md-6">
                        <input type="phone" class="form-control" placeholder="Phone Number" name="phone"
                            id="phone" style="margin: 0 !important">
                        
                        <div class="m-0 print-error-msg" id="error-phone" style="display:none; color: red;">
                        </div>
                    </div>
                </div>
                <div class="mb-3 form-item message-item col-md-12">
                    <textarea class="form-control address" placeholder="Your Message" cols="30" rows="3" name="message"
                        id="message" style="margin: 0 !important"></textarea>
                    <div class="print-error-msg" id="error-message" style="display:none; color: red;">
                    </div>
                </div>

                <div class="button">
                    <button type="submit" class="bd-primary-btn"><?php echo e(__('home.submit-now')); ?> <span><i
                                class="fa-solid fa-arrow-right"></i></span></button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->startSection('script'); ?>
    <script>
        $('#ajax-contact').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if (messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index, message) {
                            const errorMessage = $("<div>").text(message);
                            errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php /**PATH C:\OSPanel\domains\inclinc\resources\views/website/web-partials/contactform.blade.php ENDPATH**/ ?>