<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php echo $__env->yieldContent('title'); ?>
    <link rel="icon" type="image/png" href="assets/images/favicons/favicon.png" />
    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&amp;display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Syne:wght@400;500;600;700;800&amp;display=swap"
        rel="stylesheet">
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('bootstrap/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('animate/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('animate/custom-animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('fontawesome/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('odometer/odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('swiper/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('arckytec-icons/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('twentytwenty/twentytwenty.css')); ?>" />
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('arckytec.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('arckytec-responsive.css')); ?>" />
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <div class="preloader">
        <div class="preloader__image"></div>
    </div>
    <!-- /.preloader -->
    <div class="xs-sidebar-group info-group info-sidebar">
        <div class="xs-overlay xs-bg-black"></div>
        <div class="xs-sidebar-widget">
            <div class="sidebar-widget-container">
                <div class="widget-heading">
                    <a href="#" class="close-side-widget">X</a>
                </div>
                <div class="sidebar-textwidget">
                    <div class="sidebar-info-contents">
                        <div class="content-inner">
                            <div class="logo">
                                <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>"><img
                                        src="<?php echo e(url('uploads/settings/source/' . $configration->app_logo)); ?>"
                                        alt="app_logo" /></a>
                            </div>
                            <div class="form-inner">
                                <h4>Get a free quote</h4>
                                <form action="<?php echo e(LaravelLocalization::localizeUrl('save/contact-us')); ?>"
                                    class="contact-form-validated" novalidate="novalidate" method="POST">
                                    <div class="form-group">
                                        <input type="text" name="name" placeholder="<?php echo e(trans('home.name')); ?>"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="phone" placeholder="<?php echo e(trans('home.phone')); ?>"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <input type="email" name="email" placeholder="<?php echo e(trans('home.email')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <textarea name="message" placeholder="<?php echo e(trans('home.message')); ?>..."></textarea>
                                    </div>
                                    <div class="form-group message-btn">
                                        <button type="submit"
                                            class="thm-btn form-inner__btn"><?php echo e(trans('home.send')); ?></button>
                                    </div>
                                </form>
                                <div class="result"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End sidebar widget content -->
    <div class="page-wrapper">
        <!-- Start sidebar widget content -->
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--End footer Style2 area -->
        <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
            <li class="Icon call ">
                <!--<span class="tooltip ">Call</span>-->
                <a href="tel:+2<?php echo e($setting->mobile); ?>" target="_blank "><i class="fa fa-phone "></i></a>
            </li>
            <li class="Icon whatsapp ">
                <!--<span class="tooltip ">Whatsapp</span>-->
                <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank "><i class="fab fa-whatsapp"></i></a>
            </li>
        </ul>
    </div>
    <!-- /.page-wrapper -->
    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>" aria-label="logo image"><img
                        src="<?php echo e(url('uploads/settings/source/' . $configration->app_logo)); ?>" width="150"
                        alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <?php if($setting->contact_email): ?>
                    <li>
                        <i class="fa fa-envelope"></i>
                        <a href="mailto:<?php echo e($setting->contact_email); ?>"><?php echo e($setting->contact_email); ?></a>
                    </li>
                <?php endif; ?>
                <?php if($setting->mobile): ?>
                    <li>
                        <i class="fa fa-phone-alt"></i>
                        <a href="tel:+2<?php echo e($setting->mobile); ?>"><?php echo e($setting->mobile); ?></a>
                    </li>
                <?php endif; ?>
            </ul>
            <!-- /.mobile-nav__contact -->
            <div class="mobile-nav__top">
                <div class="mobile-nav__social">
                    <?php if($setting->whatsapp): ?>
                    <a href="<?php echo e($setting->whatsapp); ?>" class="fab fa-whatsapp"></a>
                    <?php endif; ?>
                    <?php if($setting->facebook): ?>
                    <a href="<?php echo e($setting->facebook); ?>" class="fab fa-facebook-square"></a>
                    <?php endif; ?>
                    <?php if($setting->instgram): ?>
                    <a href="<?php echo e($setting->instgram); ?>" class="fab fa-instagram"></a>
                    <?php endif; ?>
                </div>
                <!-- /.mobile-nav__social -->
            </div>
            <!-- /.mobile-nav__top -->
        </div>
    </div>
    <!-- /.mobile-nav__wrapper -->
    <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fas fa-arrow-up"></i></a>

    <!-- Template  JS -->
    <script src="<?php echo e(Helper::vendorFilesPath('jquery/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-ajaxchimp/jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-appear/jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-validate/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('odometer/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('swiper/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('swiper/slider-init.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('wow/wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery.circle-type/jquery.circleType.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery.circle-type/jquery.lettering.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('sidebar-content/jquery-sidebar-content.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('twentytwenty/twentytwenty.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('twentytwenty/jquery.event.move.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('marquee/marquee.min.js')); ?>"></script>
    <!-- thm custom script -->
    <script src="<?php echo e(Helper::jsFilesPath('arckytec.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\soulwater\resources\views/layouts/app.blade.php ENDPATH**/ ?>