
<section class="contact-up section-padding background-section">
    <div class="container mb-50 p-relative">
        <h5 class="sub-heading mb-15 pb-15"><?php echo e(__('home.contact-us')); ?></h5>
        <h2 class="section-title text-uppercase"><?php echo e(Helper::extractFirstWords($subheader->subheader('contact',1)->{'title_'.$lang},1)); ?>

            <strong>  <?php echo e(Helper::extractLastWords($subheader->subheader('contact',1)->{'title_'.$lang},1)); ?></strong>
        </h2>

        <p class="sm-title-block pb-50 border-bottom mt-20"><?php echo $subheader->subheader('contact',1)->{'text_'.$lang}; ?></p>
    </div>

    <div class="container">
        <div class="d-grid grid-md-3 grid-sm-2 mt-50 pb-50 border-bottom">
            <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="item">
                <h4 class="subtitle p-relative line-shap  line-shap-after mb-15 text-uppercase"><span
                        class="p-10 background-main "> <?php echo e($address->{'title_'.$lang}); ?></span>
                </h4>
                <p class="sm-title-block"><?php echo e($address->{'address_'.$lang}); ?></p>

                <a href="tel:123-456-7890" class="mt-15 theme-color"><i class="fas fa-mobile"></i> <span
                        class="ml-5"><?php echo e($address->tel); ?></span></a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <form action="<?php echo e(route('contact.save')); ?>" method="POST" data-toggle="validator" class="form w-100 mt-50"  >
            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
            <div class="messages"></div>
            <div class="input__wrap controls row">
                <div class="col-md-6 form-group">
                    <div class="entry-box">
                        <input id="form_name" type="text" name="name" placeholder="<?php echo e(__('home.entername')); ?>"
                            required="required" data-error="name is required.">
                    </div>
                    <div class="help-block with-errors"></div>
                </div>

                <div class="col-md-6 form-group">
                    <div class="entry-box">
                        <input id="form_email" type="email" name="email" placeholder="<?php echo e(__('home.enteremail')); ?>"
                            required="required" data-error="Valid email is required.">
                    </div>
                    <div class="help-block with-errors"></div>
                </div>

                <div class="col-md-12 form-group">
                    <div class="entry-box">
                        <textarea id="form_message" class="form-control" name="message"
                            placeholder="<?php echo e(__('home.tellproject')); ?>" required="required"
                            data-error="Please,leave us a message."></textarea>
                    </div>
                    <div class="help-block with-errors"></div>
                </div>

                <div class="col-md-12 text-center">
                    <div class="image-zoom w-auto d-inline-block move-circle inner-btn v-dark-head"
                        data-dsn="parallax">
                        <input type="submit" value="Send" class="dsn-btn text-uppercase">
                    </div>
                </div>
            </div>
        </form>
    </div>


</section>

<?php /**PATH C:\OSPanel\domains\pruoj\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>