<title><?php echo e(trans('home.edit_brand')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.brands')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/brands')); ?>"><?php echo e(trans('home.brands')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_brand')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/brands/'.$brand->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_brand')); ?></h6>
                        </div>

                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($brand->name_en); ?>" required>
                            </div>

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($brand->name_ar); ?>" >
                            </div>

                            <div class="form-group col-md-6">
                                <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo $brand->text_en; ?></textarea>
                            </div>

                            <div class="form-group col-md-6 ">
                                <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo $brand->text_ar; ?></textarea>
                            </div>

                            <div class="form-group col-md-6 ">
                                <label for="facebook"><?php echo e(trans('home.Facebook')); ?></label>
                                <input class="form-control area1" name="facebook" type="text" placeholder="<?php echo e(trans('home.Facebook')); ?>" value="<?php echo e($brand->facebook); ?>">
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="instagram"><?php echo e(trans('home.instagram')); ?></label>
                                <input class="form-control area1" name="instagram" type="text" placeholder="<?php echo e(trans('home.instagram')); ?>" value="<?php echo e($brand->instagram); ?>">
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="pinterest">Pinterest</label>
                                <input class="form-control area1" name="pinterest" type="text" placeholder="pinterest" value="<?php echo e($brand->pinterest); ?>">
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="youtube"><?php echo e(trans('home.youtube')); ?></label>
                                <input class="form-control area1" name="youtube" type="text" placeholder="<?php echo e(trans('home.youtube')); ?>" value="<?php echo e($brand->youtube); ?>">
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="twitter"><?php echo e(trans('home.twitter')); ?></label>
                                <input class="form-control area1" name="twitter" type="text" placeholder="<?php echo e(trans('home.twitter')); ?>" value="<?php echo e($brand->twitter); ?>">
                            </div>

                            <div class="form-group col-md-6 ">
                                <label for="address"><?php echo e(trans('home.address')); ?></label>
                                <input class="form-control area1" name="address" type="text" placeholder="<?php echo e(trans('home.address')); ?>" value="<?php echo e($brand->address); ?>">
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="phone"><?php echo e(trans('home.phone')); ?></label>
                                <input class="form-control area1" name="phone" type="text" placeholder="<?php echo e(trans('home.phone')); ?>" value="<?php echo e($brand->phone); ?>">
                            </div>

                            <div class="form-group col-md-4">
                                <label><?php echo e(trans('home.logo')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_logo')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <?php if($brand->logo): ?>
                                <div class="col-md-12">
                                    <img src="<?php echo e(url('\uploads\brands\resize200')); ?>\<?php echo e($brand->logo); ?>" width="150">
                                </div>
                            <?php endif; ?>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($brand->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.seo_block')); ?></h6>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <label for="name_ar"><?php echo e(trans('home.link')); ?></label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="<?php echo e(trans('home.link')); ?>" name="link_en" value="<?php echo e($brand->link_en); ?>">
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($brand->meta_title_en); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($brand->meta_desc_en); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <label for="name_ar"><?php echo e(trans('home.link')); ?></label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="<?php echo e(trans('home.link')); ?>" name="link_ar" value="<?php echo e($brand->link_ar); ?>">
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($brand->meta_title_ar); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($brand->meta_desc_ar); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label class="ckbox">
                                            <input name="meta_robots" value="1" <?php echo e(($brand->meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.meta_robots')); ?> (index)</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/brands')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    <?php echo Form::close(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/brands/editBrand.blade.php ENDPATH**/ ?>