<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_projects')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.projects')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a hr ef="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/projects')); ?>"><?php echo e(trans('home.projects')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_projects')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        <?php echo Form::open(['route' => 'projects.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">

                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1"><?php echo e(trans('home.add_projects')); ?></h6>
                                <hr>
                            </div>
                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                </div>

                                <div class="col-md-4">
                                    <label><?php echo e(trans('home.main_image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image" accept="image/*">

                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-2">
                                    <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                    <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>">
                                </div>
                                <br>
                                <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group col-md-3">
                                        <label class=""><?php echo e($attribute->name_ar); ?></label>
                                        <input  name="attribute[]" type="hidden" value="<?php echo e($attribute->id); ?>" >
                                        <input class="form-control" name="attribute_value[]" type="text" placeholder="Add Value">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <div class="form-group col-md-6">
                                    <label for="helperText"><?php echo e(trans('home.category')); ?></label>
                                    <select class="form-control select2" name="category_id" required>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>"><?php echo e((app()->getLocale() == 'en')?$category->name_en:$category->name_ar); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>










                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->

            <!-- End Row -->
             <!-- Row-->
             <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save_and_continue')); ?> </button>
                                    <a href="<?php echo e(url('/admin/projects')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->

        <?php echo Form::close(); ?>

</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/calibre/resources/views/admin/projects/addProject.blade.php ENDPATH**/ ?>