<!-- Bootstrap JS and jQuery from CDN -->
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>

<!-- Footer -->
<footer class="main-footer dark">
    <div class="container">
        <div class="row">

            <?php if($setting->mobile): ?>
                <div class="col-md-4 mb-30">
                    <div class="item fotcont">
                        <div class="fothead">
                            <h6><?php echo e(__('home.phone')); ?></h6>
                        </div>
                        <p><?php echo e($setting ->mobile); ?></p>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($setting->contact_email): ?>
                <div class="col-md-4 mb-30">
                    <div class="item fotcont">
                        <div class="fothead">
                            <h6><?php echo e(__('home.email')); ?></h6>
                        </div>
                        <p><?php echo e($setting->contact_email); ?></p>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($configration->address1): ?>
                <div class="col-md-4 mb-30">
                    <div class="item fotcont">
                        <div class="fothead">
                            <h6><?php echo e(__('home.address')); ?></h6>
                        </div>
                        <p><?php echo e($configration->address1); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="sub-footer">
        <div class="container">
            <div class="row">
                <div class="side-cart">
                    <div class="side-cart-content">
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modal fade bd-example-modal-lg" id="exampleModalLong_<?php echo e($page->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle_<?php echo e($page->id); ?>" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header" style="background-color: #272727">
                                            <h5 class="modal-title" style="color: #edcd97" id="exampleModalLongTitle"><?php echo e($page->{'title_'.$lang}); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body m-5">
                                               <?php echo $page->{'text_'.$lang}; ?>

                                        </div>
                                        <div class="modal-footer justify-content-center">
                                            <button type="button" class="btn btn-secondary col-6" data-dismiss="modal"><?php echo e(__('home.close')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="text-left">
                        <p>
                            All Rights Reserved <strong class="text-brand"><?php echo e($configration->app_name); ?></strong>,
                            Developed and Designed by<a href="https://www.be-group.com/" target="blank">BeGroup</a>
                        </p>
                    </div>
                </div>
                <div class="col-md-4 abot">
                    <div class="social-icon">
                        <?php if(! empty($setting->facebook)): ?>
                            <a href="<?php echo e(url($setting->facebook)); ?>">
                                <i class="ti-facebook"></i>
                            </a>

                        <?php endif; ?>
                        <?php if(! empty($setting->twitter)): ?>
                            <a href="<?php echo e(url($setting->twitter)); ?>">
                                <i class="ti-twitter"></i>
                            </a>

                        <?php endif; ?>
                        <?php if(! empty($setting->instagram)): ?>
                            <a href="<?php echo e(url($setting->instagram)); ?>">
                                <i class="ti-instagram"></i>
                            </a>

                        <?php endif; ?>
                        <?php if(! empty($setting->youtube)): ?>
                            <a href="<?php echo e(url($setting->youtube)); ?>">
                                <i class="ti-youtube"></i>
                            </a>

                        <?php endif; ?>
                        <?php if(! empty($setting->linkedin)): ?>
                            <a href="<?php echo e(url($setting->linkedin)); ?>">
                                <i class="ti-linkedin"></i>
                            </a>

                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-4">

                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p class="right">
                            <a href="javascript:avoid(0)" class="page-link" data-toggle="modal" data-target="#exampleModalLong_<?php echo e($page->id); ?>"><?php echo e($page->{'title_'.$lang}); ?></a>
                        </p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</footer>
<script src="<?php echo e(Helper::jsFilesPath('jquery-3.6.3.min.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('.page-link').on('click', function(e) {
            e.preventDefault();
            $('.side-cart, .overlay').toggleClass('show');
        });

        $('.overlay').on('click', function() {
            $('.side-cart, .overlay').removeClass('show');
        });
    });
</script>

<?php /**PATH C:\OSPanel\domains\calibra\resources\views/layouts/partials/footer.blade.php ENDPATH**/ ?>