<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <!-- Page Title -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('title', 'Neuro Surgical Clinic'); ?>
    <title>Neuro Surgical Clinic</title>
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon"
        href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>">
    <!-- Google Fonts Css-->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&amp;display=swap"
        rel="stylesheet">
    <!-- Bootstrap Css -->
    <link href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" rel="stylesheet" media="screen">
    <!-- SlickNav Css -->
    <link href="<?php echo e(Helper::cssFilesPath('slicknav.min.css')); ?>" rel="stylesheet">
    <!-- Swiper Css -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.min.css')); ?>">
    <!-- Font Awesome Icon Css-->
    <link href="<?php echo e(Helper::cssFilesPath('all.min.css')); ?>" rel="stylesheet" media="screen">
    <!-- Animated Css -->
    <link href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" rel="stylesheet">
    <!-- Magnific Popup Core Css File -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>">
    <!-- Mouse Cursor Css File -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('mousecursor.css')); ?>">
    <!-- Main Custom Css -->
    <link rel="preload" href="<?php echo e(Helper::cssFilesPath('custom.css')); ?>" as="style"
        onload="this.onload=null;this.rel='stylesheet'" media="screen" />
    
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="loading-container">
            <div class="loading"></div>
            <div id="loading-icon"><img src="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>"
                    alt=""></div>
        </div>
    </div>
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--Social Media-->
    <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($index == 0): ?>
                <li class="Icon call ">
                    <a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>" target="_blank "><img
                            src="<?php echo e(asset('resources/assets/front/images/icon/smartphone-call.webp')); ?>"
                            alt="phone"> </a>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <li class="Icon whatsapp ">
            <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank "><i
                    class="fa-brands fa-whatsapp"></i></a>
        </li>
    </ul>
    <!--Social Media-->
    <!-- Start Go Top Section -->
    
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <!-- jQuery -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>

    <!-- Jquery Library File -->
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <!-- Bootstrap js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <!-- Validator js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('validator.min.js')); ?>"></script>
    <!-- SlickNav js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery.slicknav.js')); ?>"></script>
    <!-- Swiper js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('swiper-bundle.min.js')); ?>"></script>
    <!-- Counter js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery.counterup.min.js')); ?>"></script>
    <!-- Isotop js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('isotope.min.js')); ?>"></script>
    <!-- Magnific js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <!-- SmoothScroll -->
    <script defer src="<?php echo e(Helper::jsFilesPath('SmoothScroll.js')); ?>"></script>
    <!-- Parallax js -->
    <script defer src="<?php echo e(Helper::jsFilesPath('parallaxie.js')); ?>"></script>
    <!-- MagicCursor js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('gsap.min.js')); ?>"></script>
    <script defer src="<?php echo e(Helper::jsFilesPath('magiccursor.js')); ?>"></script>
    <!-- Text Effect js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('SplitText.js')); ?>"></script>
    <script defer src="<?php echo e(Helper::jsFilesPath('ScrollTrigger.min.js')); ?>"></script>
    <!-- YTPlayer js File -->
    <script defer src="<?php echo e(Helper::jsFilesPath('jquery.mb.YTPlayer.min.js')); ?>"></script>
    <!-- Wow js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <!-- Main Custom js file -->
    <script defer src="<?php echo e(Helper::jsFilesPath('function.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\drsobhy\resources\views/layouts/app.blade.php ENDPATH**/ ?>