<!-- Start Review Wrap Area -->
@if (!empty($testimonials) && count($testimonials))
    <!-- Our Testimonial Start -->
    <div class="our-testimonials">
        <div class="container-fluid">
            <div class="row no-gutters">
                <div class="col-lg-6">
                    <!-- Our Testimonial Image Start -->
                    <div class="our-testimonials-image">
                        <figure class="image-anime">
                            <img src="{{ Helper::uploadedImagesPath('aboutStrucs', $about->image) }}" alt="">
                        </figure>
                    </div>
                    <!-- Our Testimonial Image End -->
                </div>

                <div class="col-lg-6">
                    <!-- Our Testimonial Content Start -->
                    <div class="our-testimonial-content">
                        <!-- Section Title Start -->
                        <div class="section-title">
                            <h3 class="wow fadeInUp">{{ __('home.our_clients_review') }}</h3>
                            <h2 class="text-anime-style-2" data-cursor="-opaque">{{__('home.Trusted by thousand of patients.')}}</h2>
                        </div>
                        <!-- Section Title End -->

                        <!-- Testimonial Slider Start -->
                        <div class="testimonial-slider">
                            <div class="swiper">
                                <div class="swiper-wrapper" data-cursor-text="Drag">
                                    <!-- Testimonial Slide Start -->
                                    @foreach ($testimonials as $testimonial)
                                        <div class="swiper-slide">
                                            <div class="testimonial-item">
                                                <div class="testimonial-body">
                                                    <div class="testimonial-content">
                                                        <p>{!!$testimonial->{'text_'.$lang}!!}</p>
                                                    </div>
                                                </div>
                                                <div class="testimonial-body">
                                                    <div class="author-image">
                                                        <figure class="image-anime">
                                                            <img src="{{ Helper::uploadedImagesPath('testimonials', $testimonial->img) }}" alt="">
                                                        </figure>
                                                    </div>
                                                    <div class="author-content">
                                                        <h3>{{ $testimonial->{'name_' . $lang} }}</h3>
                                                        <p>{{$testimonial->{'position_'.$lang} }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    <!-- Testimonial Slide End -->
                                </div>
                            </div>
                        </div>
                        <!-- Testimonial Slider End -->

                    </div>
                    <!-- Our Testimonial Content End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Our Testimonial End -->
@endif
<!-- End Review Wrap Area -->
