@extends('layouts.admin')
<title>{{trans('home.send_email_message')}}</title>
@section('content')
<div class="container">
    <h1> {{trans('home.send_email_message')}}</h1>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>{{__('home.email')}}</th>
                <th>{{__('home.messages')}}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($contacts as $contact)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $contact->email }}</td>
                    <td>
                        <button class="btn btn-primary" onclick="fillEmail('{{ $contact->email }}')">{{__('home.send_email_message')}}</button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table> --}}

    <form method="POST" action="{{ route('contacts.send') }}">
        @csrf
        {{-- <div class="form-group">
            <label for="email">{{__('home.email')}}</label>
            <input type="email" id="email" name="email" class="form-control" readonly>
        </div> --}}
        <div class="row">
        <div class="form-group col-md-6 mb-3" >
            <label for="subject">{{__('home.subject')}}</label>
            <input type="text" id="subject" name="subject" class="form-control" required>
        </div>
        <div class="form-group col-md-6 mb-3">
        <label for="email">Select Emails:</label>
    <select class="form-control menu_type select2" name="emails[]" multiple>
        <option value="" disabled>choose the email</option>
        <option value="select_all" id="select-all-option">Select All</option>
        @foreach($contacts as $contact)
        <option value="{{ $contact->email }}">{{ $contact->email }}</option>
        @endforeach
    </select><br>
</div>
</div>
        <div class="form-group">
            <label for="message">{{__('home.messages')}}</label>
            <textarea id="message" name="message" class="form-control" rows="4"></textarea>
        </div>
        <button type="submit" class="btn btn-success">{{__('home.send')}}</button>
    </form>
</div>

<script>
    function fillEmail(email) {
        document.getElementById('email').value = email;
    }
</script>
@endsection
@section('script')
<script>
selectElement.addEventListener('change', function (event) {
    if (event.target.value === 'select_all') {
        for (let i = 0; i < selectElement.options.length; i++) {
            selectElement.options[i].selected = true;
        }
    } else {
        selectAllOption.selected = false;
    }
});
</script>
@endsection
