<?php

namespace App\Providers;

use App\Models\About;
use App\Models\AboutStruc;
use App\Models\Career;
use App\Models\Date;
use App\Models\Progress;
use App\Models\Phone;
use App\Models\Project;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App;
use View;
use App\Models\Setting;
use App\Models\Configration;
use App\Models\MenuItem;
use App\Models\Page;
use Auth;
use App\Models\Category;
use App\Models\Footer;
use App\Models\Service;
use App\Models\GalleryImage;
use App\Models\Address;
use App\Models\SeoAssistant;
use App\Models\BlogCategory;
use App\Models\Writer;
use App\Models\Region;
use App\Models\Brand;
use App\Models\BlogItem;
use App\Models\Team;
use App\Models\Subheader;
use App\Models\Album;
use App\Models\HomeSlider;
use App\Models\IntroSlider;
use App\Models\GalleryVideo;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
        Schema::defaultStringLength(191);
        \URL::forceScheme('https');

        view()->composer('*', function($view)
        {
            $setting = Setting::first();
            $seo = SeoAssistant::first();
            $writers = Writer::where('status',1)->get();
            $lang = \LaravelLocalization::getCurrentLocale();
            App::setlocale($lang);
            $blogCategories= BlogCategory::orderBy('id','desc')->get();
            $configration = Configration::where('lang',$lang)->first();
            $menus = MenuItem::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $footerMenus = MenuItem::where('menu_id',2)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $pages = Page::where('status',1)->get();
            $menuServices = Service::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(6)->get();
            $intro_slider = IntroSlider::where('status',1)->first();
            $services  = Service::where('menu',1)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(3)->get();
            $categories = Category::where('status',1)->where('home',1)->take(3)->get();

            $menuCategories = Category::where('menu',1)->where('status',1)->get();
            $brands = Brand::where('status',1)->get();
            $lang=\App::getLocale();

            $addresses = Address::where('status',1)->take(3)->get();
            $twoaddresses = Address::where('status',1)->take(2)->get();
            $lastAddress = Address::where('status', 1)->first();

            $statements = Career::where('status',1)->where('type','header')->get();
            $dates = Date::where('status',1)->get();
            $phones = Phone::where('status',1)->orderBy('order','ASC')->get();
            $progressesabout = Progress::where('status',1)->where('type','About us')->orderBy('order','ASC')->get();
            $progresses = Progress::where('status',1)->orderBy('order','ASC')->get();
            $progress = Progress::where('status',1)->orderBy('order','ASC')->first();
            $custom_products = Project::where('status',1)->where('recommended',1)->get();
            $aboutStrucs  = AboutStruc::where('status',1)->where('lang',$lang)->get();
            $about = About::first();
            $footer = Footer::first();
            $blogs = BlogItem::where('status',1)->get();
            $phone = Phone::where('status', 1)->first();
            $headerSections = Subheader::where('status',1)->orderBy('order','ASC')->get();
            $headerSection = Subheader::where('status',1)->orderBy('order','ASC')->first();
            $sec  = new Career;
            $teams = Team::where('status',1)->get();
            $subheader = new Subheader;
            $albumawards = Album::where('status',1)->where('type','images')->where('name_en','awards')->get();
            $albumImages = new Album();
            $projects = Project::where('status',1)->where('recommended',1)->take(5)->get();
            $sliders = HomeSlider :: where('status',1)->get();
            $video =GalleryVideo::where('status',1)->orderBy('order','asc')->first();


        $galleryImages = GalleryImage::where('status',1)->orderBy('order','asc')->get();
//            $menubrands  = Brand::where('status',1)->get();
//            $footerServices = Service::where('parent_id',0)->where('status',1)->orderBy('order')->orderBy('name_ar')->take(6)->get();;
//            $regions = Region::where('status',1)->where('available_units',1)->get();

            App::setlocale($lang);
            View::share('language', $lang);
            View::share('services', $services);
            View::share('categories', $categories);
            View::share('setting', $setting);
            View::share('configration', $configration);
            View::share('menus', $menus);
            View::share('pages', $pages);
            View::share('lang', $lang);
            View::share('blogCategories', $blogCategories);
            View::share('addresses', $addresses);
            View::share('writers', $writers);
            View::share('seo', $seo);
            View::share('footerMenus', $footerMenus);
            View::share('menuCategories', $menuCategories);
            View::share('brands', $brands);
            View::share('statements', $statements);
            View::share('dates', $dates);
            View::share('phones', $phones);
            View::share('progresses', $progresses);
            View::share('progressesabout', $progressesabout);
            View::share('progress', $progress);
            View::share('custom_products', $custom_products);
            View::share('menuServices', $menuServices);
            View::share('aboutStrucs', $aboutStrucs);
            View::share('about', $about);
            View::share('footer', $footer);
            View::share('blogs', $blogs);
            View::share('phone' , $phone);
            View::share('lastAddress' , $lastAddress);
            View::share('headerSections' , $headerSections);
            View::share('headerSection' , $headerSection);
            View::share('sec' , $sec);
            View::share('teams' , $teams);
            View::share('subheader' , $subheader);
            View::share('albumawards' ,   $albumawards);
            View::share('albumImages' ,   $albumImages);
            View::share('projects' ,   $projects);
            View::share('galleryImages' ,   $galleryImages);
            View::share('twoaddresses' ,   $twoaddresses);
            View::share('sliders' , $sliders);
            View::share('video' , $video);
            View::share('intro_slider' , $intro_slider);



        });
    }
}
