<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_setting')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.edit_setting')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_setting')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_setting')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/settings/'.$settings->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-12">
                                    <label for="helperText"><?php echo e(trans('home.default_lang')); ?></label>
                                    <select class="form-control select2" name="default_lang" required>
                                        <option value="en" <?php echo e(($settings->default_lang=="en")?'selected':''); ?>><?php echo e(trans('home.english')); ?></option>
                                        <option value="ar" <?php echo e(($settings->default_lang=="ar")?'selected':''); ?>><?php echo e(trans('home.arabic')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.contact_email')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.contact_email')); ?>" name="contact_email" value="<?php echo e($settings->contact_email); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.email')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.email')); ?>" name="email" value="<?php echo e($settings->email); ?>">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class=""><?php echo e(trans('home.telphone')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.telphone')); ?>" name="telphone" value="<?php echo e($settings->telphone); ?>">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile" value="<?php echo e($settings->mobile); ?>">
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label class=""><?php echo e(trans('home.telphone2')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.telphone2')); ?>" name="telphone2" value="<?php echo e($settings->telphone2); ?>">
                                </div>

                                <div class="form-group col-md-2">
                                    <label class=""><?php echo e(trans('home.mobile2')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile2')); ?>" name="mobile2" value="<?php echo e($settings->mobile2); ?>">
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.fax')); ?></label>
                                    <input type="fax"  min="0" class="form-control" placeholder="<?php echo e(trans('home.fax')); ?>" name="fax" value="<?php echo e($settings->fax); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.whatsapp')); ?></label>
                                    <input type="whatsapp"  min="0" class="form-control" placeholder="<?php echo e(trans('home.whatsapp')); ?>" name="whatsapp" value="<?php echo e($settings->whatsapp); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.snapchat')); ?></label>
                                    <input type="text"  min="0" class="form-control" placeholder="<?php echo e(trans('home.snapchat')); ?>" name="youtube" value="<?php echo e($settings->youtube); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="facebook"><?php echo e(trans('home.facebook')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.facebook')); ?>" name="facebook" value="<?php echo e($settings->facebook); ?>">
                                </div>
								<div class="form-group col-md-6">
                                    <label for="linkedin"><?php echo e(trans('home.linkedin')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.linkedin')); ?>" name="linkedin" value="<?php echo e($settings->linkedin); ?>">
                                </div>
								 <div class="form-group col-md-6">
                                    <label for="instgram"><?php echo e(trans('home.instgram')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.instgram')); ?>" name="instgram" value="<?php echo e($settings->instgram); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="twitter"><?php echo e(trans('home.twitter')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.twitter')); ?>" name="twitter" value="<?php echo e($settings->twitter); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="alert_name_en"><?php echo e(trans('home.alert_name_en')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.alert_name_en')); ?>" name="alert_name_en" value="<?php echo e($settings->alert_name_en); ?>">
									</textarea>
                                </div>
								<div class="form-group col-md-6">
                                    <label for="alert_name_ar"><?php echo e(trans('home.alert_name_ar')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.alert_name_ar')); ?>" name="alert_name_ar" value="<?php echo e($settings->alert_name_ar); ?>">
									</textarea>
                                </div>
								 <div class="form-group col-md-6">
                                    <label for="alert_text_en"><?php echo e(trans('home.alert_text_en')); ?></label>
									<textarea class="form-control" name="alert_text_en" type="text" placeholder="<?php echo e(trans('home.alert_text_en')); ?>"><?php echo e($settings->alert_text_en); ?></textarea>
								</div>
								 <div class="form-group col-md-6">
                                    <label for="alert_text_ar"><?php echo e(trans('home.alert_text_ar')); ?></label>
									<textarea class="form-control" name="alert_text_ar" type="text" placeholder="<?php echo e(trans('home.alert_text_ar')); ?>"><?php echo e($settings->alert_text_ar); ?></textarea>
								</div>



                                <div class="col-md-12">
                                    <label><?php echo e(trans('home.map_url')); ?></label>
                                    <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"><?php echo e($settings->map_url); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="latitude"><?php echo e(trans('home.latitude')); ?></label>
                                    <input type="text"  placeholder="<?php echo e(trans('home.latitude')); ?>" id="latitude" class="form-control" name="lat" value="<?php echo e($settings->lat); ?>" readonly>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="longitude"><?php echo e(trans('home.longitude')); ?></label>
                                    <input type="text" id="longitude" class="form-control" placeholder="<?php echo e(trans('home.longitude')); ?>" name="lng" value="<?php echo e($settings->lng); ?>" readonly>
                                </div>

                                <div class="form-group col-md-12">
                                    <label for="map"><?php echo e(trans('home.map')); ?></label>
                                    <div id="map-canvas" style="height: 350px; margin-bottom: 15px;"></div>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.cetificates')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.cetificates')); ?>" name="cetificates" value="<?php echo e($settings->cetificates); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.exp_years')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.exp_years')); ?>" name="exp_years" value="<?php echo e($settings->exp_years); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.surgeries')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.surgeries')); ?>" name="surgeries" value="<?php echo e($settings->surgeries); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.consult')); ?></label>
                                    <input type="number"  min="0" class="form-control" placeholder="<?php echo e(trans('home.consult')); ?>" name="consult" value="<?php echo e($settings->consult); ?>">
                                </div>
                                
                                

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB2DM4_HwOA3s6WsWcyhRt5Q_NO9CoxZpU&callback=initMap2" async defer></script>
    <script>

        $('.lang').select2({
        });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/bmk/resources/views/admin/settings/setting.blade.php ENDPATH**/ ?>